/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.FileType;
import DE.siemens.ad.logo.app.FileTypeGroup;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class LogoFileView
extends FileView {
    public Vector fFileTypes;

    public LogoFileView() {
    }

    public LogoFileView(Collection fileTypes) {
        this.addFileTypes(fileTypes);
    }

    public void addFileType(FileType newFileType) {
        if (newFileType instanceof FileTypeGroup) {
            Enumeration e = ((FileTypeGroup)newFileType).getFileTypes().elements();
            while (e.hasMoreElements()) {
                this.addFileType((FileType)e.nextElement());
            }
        } else if (!this.getFileTypes().contains(newFileType)) {
            this.getFileTypes().add(newFileType);
        }
    }

    public void addFileTypes(Collection newFileTypes) {
        Iterator i = newFileTypes.iterator();
        while (i.hasNext()) {
            this.addFileType((FileType)i.next());
        }
    }

    public String getDescription(File f) {
        return this.getFileType(f).getDescription();
    }

    public FileType getFileType(File file) {
        Enumeration e = this.getFileTypes().elements();
        FileType fileType = null;
        while (e.hasMoreElements()) {
            fileType = (FileType)e.nextElement();
            if (!file.getName().toLowerCase().endsWith(fileType.getExtension().toLowerCase())) continue;
            return fileType;
        }
        return null;
    }

    public Vector getFileTypes() {
        if (this.fFileTypes == null) {
            this.fFileTypes = new Vector();
        }
        return this.fFileTypes;
    }

    public Icon getIcon(File f) {
        if (FileSystemView.getFileSystemView().isTraversable(f).booleanValue()) {
            return null;
        }
        FileType fileType = this.getFileType(f);
        if (fileType != null) {
            return fileType.getIcon();
        }
        return null;
    }

    public String getName(File f) {
        return null;
    }

    public String getTypeDescription(File f) {
        return null;
    }

    public Boolean isTraversable(File f) {
        if (f == null) {
            return Boolean.FALSE;
        }
        return f.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void removeFileType(FileType newFileType) {
        this.getFileTypes().remove(newFileType);
    }
}

